/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class SVNKeywords {
    public static final String LAST_CHANGED_DATE = "LastChangedDate";
    public static final String DATE = "Date";
    public static final String LAST_CHANGED_REVISION = "LastChangedRevision";
    public static final String REV = "Rev";
    public static final String LAST_CHANGED_BY = "LastChangedBy";
    public static final String AUTHOR = "Author";
    public static final String HEAD_URL = "HeadURL";
    public static final String URL = "URL";
    public static final String ID = "Id";
    private boolean lastChangedDate = false;
    private boolean lastChangedRevision = false;
    private boolean lastChangedBy = false;
    private boolean headUrl = false;
    private boolean id = false;

    public SVNKeywords() {
    }

    public SVNKeywords(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(HEAD_URL) || string2.equals(URL)) {
                this.headUrl = true;
                continue;
            }
            if (string2.equals(ID)) {
                this.id = true;
                continue;
            }
            if (string2.equals(LAST_CHANGED_BY) || string2.equals(AUTHOR)) {
                this.lastChangedBy = true;
                continue;
            }
            if (string2.equals(LAST_CHANGED_DATE) || string2.equals(DATE)) {
                this.lastChangedDate = true;
                continue;
            }
            if (!string2.equals(LAST_CHANGED_REVISION) && !string2.equals(REV)) continue;
            this.lastChangedRevision = true;
        }
    }

    public SVNKeywords(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.lastChangedDate = bl;
        this.lastChangedRevision = bl2;
        this.lastChangedBy = bl3;
        this.headUrl = bl4;
        this.id = bl5;
    }

    public boolean isHeadUrl() {
        return this.headUrl;
    }

    public boolean isId() {
        return this.id;
    }

    public boolean isLastChangedBy() {
        return this.lastChangedBy;
    }

    public boolean isLastChangedDate() {
        return this.lastChangedDate;
    }

    public boolean isLastChangedRevision() {
        return this.lastChangedRevision;
    }

    public List getKeywordsList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.headUrl) {
            arrayList.add(HEAD_URL);
        }
        if (this.id) {
            arrayList.add(ID);
        }
        if (this.lastChangedBy) {
            arrayList.add(LAST_CHANGED_BY);
        }
        if (this.lastChangedDate) {
            arrayList.add(LAST_CHANGED_DATE);
        }
        if (this.lastChangedRevision) {
            arrayList.add(LAST_CHANGED_REVISION);
        }
        return arrayList;
    }

    public String toString() {
        String string = "";
        Iterator iterator = this.getKeywordsList().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string = string + string2;
            if (!iterator.hasNext()) continue;
            string = string + ' ';
        }
        return string;
    }

    public void setHeadUrl(boolean bl) {
        this.headUrl = bl;
    }

    public void setId(boolean bl) {
        this.id = bl;
    }

    public void setLastChangedBy(boolean bl) {
        this.lastChangedBy = bl;
    }

    public void setLastChangedDate(boolean bl) {
        this.lastChangedDate = bl;
    }

    public void setLastChangedRevision(boolean bl) {
        this.lastChangedRevision = bl;
    }
}

