<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/id-card-print.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('main-content'); ?>

	<section class="section">
        <div class="section-header">
            <h1><?php echo e(__('Visitors')); ?></h1>
            <?php echo e(Breadcrumbs::render('visitors/show')); ?>

        </div>

        <div class="section-body">
        	<div class="row">
	   			<div class="col-4 col-md-4 col-lg-4">
			    	<div class="card">
                        <div class="card-header">
                            <a href="#" id="print" class="btn btn-icon icon-left btn-primary"><i class="fas fa-print"></i> <?php echo e(__('Print ID card')); ?></a>
                        </div>
					    <div class="card-body ">
                            <div class="img-cards" id="printidcard">
                                <div class="id-card-holder">
                                    <div class="id-card">
                                        <div class="id-card-photo">
                                            <?php if($visitingDetails->getFirstMediaUrl('visitor')): ?>
                                                <img src="<?php echo e(asset($visitingDetails->getFirstMediaUrl('visitor'))); ?>" alt="">
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('images/'.setting('id_card_logo'))); ?>" alt="">
                                            <?php endif; ?>
                                        </div>
                                        <h2><?php echo e($visitingDetails->visitor->name); ?></h2>
                                        <h3><?php echo e(__('Ph: ')); ?><?php echo e($visitingDetails->visitor->phone); ?></h3>
                                        <h3><?php echo e(__('ID#')); ?><?php echo e($visitingDetails->reg_no); ?></h3>
                                        <h3><?php echo e($visitingDetails->company_name); ?></h3>
                                        <h3><?php echo e($visitingDetails->visitor->address); ?></h3>
                                        <h2><?php echo e(__('VISITED TO')); ?></h2>
                                        <h3><?php echo e(__('Host:')); ?> <?php echo e($visitingDetails->employee->name); ?></h3>
                                        <hr>
                                        <p><strong><?php echo e(setting('site_name')); ?> </strong></p>
                                        <p><strong><?php echo e(setting('site_address')); ?> </strong></p>
                                        <p><?php echo e(__('Ph:')); ?> <?php echo e(setting('site_phone')); ?> | <?php echo e(__('E-mail:')); ?> <?php echo e(setting('site_email')); ?> </p>
                                    </div>
                                </div>
                            </div>
                        </div>
					    <!-- /.box-body -->
					</div>
				</div>
	   			<div class="col-8 col-md-8 col-lg-8">
			    	<div class="card">
			    		<div class="card-body">
			    			<div class="profile-desc">
			    				<div class="single-profile">
			    					<p><b><?php echo e(__('First Name')); ?>: </b> <?php echo e($visitingDetails->visitor->first_name); ?></p>
			    				</div>
			    				<div class="single-profile">
			    					<p><b><?php echo e(__('Last Name')); ?>: </b> <?php echo e($visitingDetails->visitor->last_name); ?></p>
			    				</div>
			    				<div class="single-profile">
			    					<p><b><?php echo e(__('Email')); ?>: </b> <?php echo e($visitingDetails->visitor->email); ?></p>
			    				</div>
			    				<div class="single-profile">
			    					<p><b><?php echo e(__('Phone')); ?>: </b> <?php echo e($visitingDetails->visitor->phone); ?></p>
			    				</div>
                                <div class="single-profile">
			    					<p><b><?php echo e(__('Employee')); ?>: </b> <?php echo e($visitingDetails->employee->user->name); ?></p>
			    				</div>
                                <div class="single-profile">
                                    <p><b><?php echo e(__('Purpose')); ?>: </b> <?php echo e($visitingDetails->purpose); ?></p>
                                </div>
                                <div class="single-profile">
                                    <p><b><?php echo e(__('Company')); ?>: </b> <?php echo e($visitingDetails->company_name); ?></p>
                                </div>
                                <div class="single-profile">
                                    <p><b><?php echo e(__('National Identification')); ?>: </b> <?php echo e($visitingDetails->national_identification_no); ?></p>
                                </div>
			    				<div class="single-profile">
			    					<p><b><?php echo e(__('Date')); ?>: </b> <?php echo e(date('d-m-Y', strtotime($visitingDetails->created_at))); ?></p>
			    				</div>
                                <div class="single-profile">
			    					<p><b><?php echo e(__('Checkin')); ?>: </b> <?php echo e(date('d-m-Y h:i A', strtotime($visitingDetails->checkin_at))); ?></p>
			    				</div>
                                <?php if($visitingDetails->checkout_at): ?>
                                <div class="single-profile">
			    					<p><b><?php echo e(__('Checkout')); ?>: </b> <?php echo e(date('d-m-Y h:i A', strtotime($visitingDetails->checkout_at))); ?></p>
			    				</div>
                                <?php endif; ?>
                                <div class="single-profile">
                                    <p><b><?php echo e(__('Address')); ?>: </b> <?php echo e($visitingDetails->visitor->address); ?></p>
                                </div>
                                <div class="single-profile">
                                    <p><b><?php echo e(__('Status')); ?>: </b> <?php echo e($visitingDetails->my_status); ?></p>
                                </div>
			    			</div>
			    		</div>
			    	</div>
				</div>
        	</div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/modules/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/modules/datatables.net-select-bs4/css/select.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/modules/datatables/media/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/modules/datatables.net-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/modules/datatables.net-select-bs4/js/select.bootstrap4.min.js')); ?>"></script>

    <script>
        var idCardCss = "<?php echo e(asset('css/id-card-print.css')); ?>";
    </script>

    <script src="<?php echo e(asset('js/visitor/view.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\visitorpass\resources\views/admin/visitor/show.blade.php ENDPATH**/ ?>