<?php $__env->startSection('main-content'); ?>

    <section class="section">
        <div class="section-header">
            <h1><?php echo e(__('Employees')); ?></h1>
            <?php echo e(Breadcrumbs::render('employees/show')); ?>

        </div>

        <div class="section-body">
            <div class="row mt-sm-4">
                <div class="col-12 col-md-12 col-lg-4">
                    <div class="card">
                        <div class="profile-dashboard bg-maroon-light">
                            <img src="<?php echo e($employee->user->images); ?>" alt="">
                            <h1><?php echo e($employee->user->name); ?></h1>
                            <p>
                                <?php echo e($employee->user->getrole->name ?? ''); ?>

                            </p>
                        </div>
                        <div class="profile-widget-description profile-widget-employee">
                            <dl class="row">
                                <dt class="col-sm-4"><?php echo e(__('Name')); ?></dt>
                                <dd class="col-sm-8"><?php echo e($employee->user->name); ?></dd>
                                <dt class="col-sm-4"><?php echo e(__('Phone')); ?></dt>
                                <dd class="col-sm-8"><?php echo e($employee->user->phone); ?></dd>
                                <dt class="col-sm-4"><?php echo e(__('Email')); ?></dt>
                                <dd class="col-sm-8"><?php echo e($employee->user->email); ?></dd>
                                <dt class="col-sm-4"><?php echo e(__('Joining Date')); ?></dt>
                                <dd class="col-sm-8"><?php echo e($employee->date_of_joining); ?></dd>
                                <dt class="col-sm-4"><?php echo e(__('Gender')); ?></dt>
                                <dd class="col-sm-8"><?php echo e($employee->mygender); ?></dd>
                                <dt class="col-sm-4"><?php echo e(__('Department')); ?></dt>
                                <dd class="col-sm-8"><?php echo e($employee->department->name); ?></dd>
                                <dt class="col-sm-4"><?php echo e(__('Designation')); ?></dt>
                                <dd class="col-sm-8"><?php echo e($employee->designation->name); ?></dd>
                                <dt class="col-sm-4"><?php echo e(__('Status')); ?></dt>
                                <dd class="col-sm-8"><?php echo e($employee->mystatus); ?></dd>
                            </dl>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-12 col-lg-8">
                    <nav>
                        <div class="nav nav-tabs" id="nav-tab" role="tablist">
                            <a class="nav-item nav-link active" id="nav-visitor-tab" data-toggle="tab"
                               href="#nav-visitor" role="tab" aria-controls="nav-visitor"
                               aria-selected="true">Visitors</a>
                            <a class="nav-item nav-link" id="nav-register-tab" data-toggle="tab" href="#nav-register"
                               role="tab" aria-controls="nav-register" aria-selected="false">Pre-registers</a>
                        </div>
                    </nav>
                    <div class="tab-content" id="nav-tabContent">
                        <div class="tab-pane fade show active" id="nav-visitor" role="tabpanel"
                             aria-labelledby="nav-visitor-tab">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped" id="visitortable"
                                               data-url="<?php echo e(route('admin.employees.get-visitors',$employee)); ?>"
                                               data-status="<?php echo e(\App\Enums\Status::ACTIVE); ?>"
                                               data-hidecolumn="<?php echo e(auth()->user()->can('visitors_show') || auth()->user()->can('visitors_edit') || auth()->user()->can('visitors_delete')); ?>">
                                            <thead>
                                            <tr>
                                                <th><?php echo e(__('levels.id')); ?></th>
                                                <th><?php echo e(__('image')); ?></th>
                                                <th><?php echo e(__('levels.name')); ?></th>
                                                <th><?php echo e(__('levels.email')); ?></th>
                                                <th><?php echo e(__('Checkin')); ?></th>
                                                <th><?php echo e(__('levels.actions')); ?></th>
                                            </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="nav-register" role="tabpanel" aria-labelledby="nav-register-tab">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped" id="preregistertable"
                                               data-url="<?php echo e(route('admin.employees.get-pre-registers',$employee)); ?>"
                                               data-status="<?php echo e(\App\Enums\Status::ACTIVE); ?>"
                                               data-hidecolumn="<?php echo e(auth()->user()->can('pre-registers_show') || auth()->user()->can('pre-registers_edit') || auth()->user()->can('pre-registers_delete')); ?>">
                                            <thead>
                                            <tr>
                                                <th scope="col"><?php echo e(__('levels.id')); ?></th>
                                                <th scope="col"><?php echo e(__('levels.name')); ?></th>
                                                <th scope="col"><?php echo e(__('levels.email')); ?></th>
                                                <th scope="col"><?php echo e(__('levels.phone')); ?></th>
                                                <th scope="col"><?php echo e(__('Expected Date')); ?></th>
                                                <th scope="col"><?php echo e(__('Expected Time')); ?></th>
                                                <th scope="col"><?php echo e(__('levels.actions')); ?></th>
                                            </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/modules/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/modules/datatables.net-select-bs4/css/select.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/modules/datatables/media/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/modules/datatables.net-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/modules/datatables.net-select-bs4/js/select.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/employee/view.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\iNilabs_project\vps\resources\views/admin/employee/show.blade.php ENDPATH**/ ?>